#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_Rack : BaseTest 
	{

		private Rack _tstRack;
		
		private DataTable _dtRack;
		private DataTable _dtDailyQcWorklist;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			_tstRack = new BOL.Rack();

			if (this.RefreshData)
			{
				//***Get the Rack data, Racks die easily, so we dont exception on no recs found - then update
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND RackGuid IN (SELECT RackGuid FROM DailyQcWorklist)", false);
				if (this._dtRack.Rows.Count == 0)
				{
					UnitTestUtil.RunSQL("UPDATE Rack SET RecordStatusCode = 'A' WHERE DailyControlGuid IN (SELECT TOP 1 DailyControlGUid FROM Rack WHERE DailyControlGuid IS NOT NULL AND DivisionCode = '" + this.TestDivisionCode + "')");
					this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND RackGuid IN (SELECT RackGuid FROM DailyQcWorklist)", true);
				}				
	
				this._dtDailyQcWorklist = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM DailyQcWorklist WHERE RackGuid = '" + this._dtRack.Rows[0][TABLES.Rack.RackGuid].ToString() + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(!_tstRack.Equals(null));
			Assert.AreEqual(_tstRack,_tstRack);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			System.Guid rackGuid=(System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			BOL.Rack tmpRack=new Rack(rackGuid);

			Assert.IsNotNull(tmpRack);
		}

		[Test]
		[ExpectedException(typeof(IndexOutOfRangeException))]
		public void Ctor_Guid_Fail()
		{
			System.Guid rackGuid=System.Guid.Empty;
			BOL.Rack tmpRack=new Rack(rackGuid);

			Assert.IsNotNull(tmpRack);
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{	
			System.Guid unitGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			BOL.Rack objTest = new BOL.Rack(this._dtRack.Rows[0]);

			Assert.IsTrue(objTest.RackGuid == unitGuid);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(NullReferenceException))]
		public void Ctor_DataRow_Fail()
		{	
			BOL.Rack _tstRack = new BOL.Rack( (DataRow)null );			
			Assert.IsNull( _tstRack );
		}

		[Test]
		public void GetDailyQCRacks_Pass()
		{
			DataTable dt = BOL.Rack.GetDailyQCRacks(BOL.VBECSDateTime.GetDivisionCurrentDateTime());
			Assert.IsTrue(dt != null);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDailyQCRacks_Fail()
		{
		}

		[Test]
		public void UpdateRackDailyUse_Pass()
		{
			this.RefreshData = true;

			System.Guid worklistGuid = (System.Guid)this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid];
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			byte[] rowVersion = (byte[])this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.RowVersion];

			bool retVal = Rack.UpdateRackDailyUse(worklistGuid, true, true, Common.UpdateFunction.UnitTests, rowVersion, rackGuid, System.DateTime.Now);
			Assert.IsTrue(retVal);
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateRackDailyUse_Fail()
		{
			System.Guid worklistGuid = (System.Guid)this._dtDailyQcWorklist.Rows[0][TABLES.DailyQcWorklist.DailyQcWorklistGuid];
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];

			bool retVal = Rack.UpdateRackDailyUse(worklistGuid, true, true, Common.UpdateFunction.UnitTests, new byte[0], rackGuid , System.DateTime.Now);
			Assert.IsTrue(!retVal);
		}

		[Test]
		public void GetConfigurableRackQC_Pass()
		{
			Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;
			DataTable dt = DAL.DailyControl.GetDailyControl();
            Assert.IsTrue(DAL.Rack.GetConfigurableRackQC((System.Guid) dt.Rows[0]["DailyControlGuid"]).Rows.Count >= 0);
		}

		[Test]
		public void GetConfigurableRackQC_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;
			Assert.IsTrue(DAL.Rack.GetConfigurableRackQC(Guid.NewGuid()).Rows.Count == 0);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{	
			System.Guid unitGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];

			BOL.Rack objTest = new BOL.Rack(unitGuid);
			DataRow drTest = objTest.LoadDataRowFromThis(this._dtRack.NewRow());
		
			System.Guid guidTest = (System.Guid)drTest[TABLES.Rack.RackGuid];
			//Should check all LoadFrom... fields
			Assert.IsTrue(guidTest == unitGuid);
		}
		
		
		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void LoadDataRowFromThis_Fail()
		{	
			System.Guid unitGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];

			BOL.Rack objTest = new BOL.Rack(unitGuid);
			DataRow drTest = objTest.LoadDataRowFromThis(new DataTable().NewRow());
		}

		[Test]
		public void RackGuid_Pass()
		{
			System.Guid _RackGuid;
			_RackGuid = _tstRack.RackGuid;
			Assert.AreEqual(_tstRack.RackGuid,_RackGuid);
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=_tstRack.BrokenRulesCount;
			_tstRack.RackGuid= Guid.NewGuid();
			brokenRulesAfter=_tstRack.BrokenRulesCount;
			Assert.AreEqual(brokenRulesAfter, brokenRulesBefore);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RackGuid_Fail()
		{
		}

		[Test]
		public void RackName_Get()
		{
			string sName = _tstRack.RackName;
			Assert.AreEqual(_tstRack.RackName, sName);
		}
		
		[Test]
		public void RackName_Set()
		{
			_tstRack.RackName = "A";
			Assert.AreEqual(_tstRack.RackName, "A");
		}

		
		[Test]
		public void DailyQcExpirationDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			_tstRack.DailyQcExpirationDate = tstValue;

			Assert.AreEqual(tstValue, _tstRack.DailyQcExpirationDate);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RackName_Fail()
		{
		}

		[Test]
		public void DailyUseIndicator_Pass()
		{
			System.Boolean _DailyUseIndicator;
			_DailyUseIndicator = _tstRack.DailyUseIndicator;
			Assert.AreEqual(_tstRack.DailyUseIndicator,_DailyUseIndicator);
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=_tstRack.BrokenRulesCount;
			_tstRack.DailyUseIndicator= true;
			brokenRulesAfter=_tstRack.BrokenRulesCount;
			Assert.AreEqual(brokenRulesAfter, brokenRulesBefore);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DailyUseIndicator_Fail()
		{
		}

		[Test]
		public void Reagents_Pass()
		{
			DataTable _Reagents;
			_Reagents = _tstRack.Reagents;
			Assert.AreEqual(_tstRack.Reagents,_Reagents);	
			
			int brokenRulesBefore;
			int brokenRulesAfter;

			brokenRulesBefore=_tstRack.BrokenRulesCount;
			_tstRack.Reagents= new DataTable();
			brokenRulesAfter=_tstRack.BrokenRulesCount;
			Assert.AreEqual(brokenRulesAfter, brokenRulesBefore);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Reagents_Fail()
		{
		}
		
		[Test]
		public void DailyControl_Pass()
		{
			gov.va.med.vbecs.BOL.DailyControl _DailyControl;
			_DailyControl = _tstRack.DailyControl;
			Assert.AreEqual(_tstRack.DailyControl,_DailyControl);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DailyControl_Fail()
		{
		}

		[Test]
		public void PartiallyTestedIndicator_Pass()
		{
			this._tstRack.PartiallyTestedIndicator = true;
			Assert.AreEqual(this._tstRack.PartiallyTestedIndicator, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PartiallyTestedIndicator_Fail()
		{
		}

		[Test]
		public void IsRackQCd_Pass()
		{
			_tstRack.DailyQcExpirationDate=DateTime.Today;
			bool isQCd=this._tstRack.IsRackQCd(DateTime.Today);

			Assert.IsTrue(isQCd);
		}

		[Test]
		public void IsRackQCd_Fail()
		{
			bool isQCd=this._tstRack.IsRackQCd(DateTime.Today.AddYears(-15));

			Assert.IsTrue(!isQCd);
		}

		[Test]
		public void GetRackTestDate_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 DailyQcWorklistGuid FROM dbo.RackLot" );
			//
			Guid dailyQcWorklistGuid = Guid.NewGuid();
			string insertDailyQc = "INSERT INTO DAILYQCWORKLIST (";
			insertDailyQc += TABLES.DailyQcWorklist.DailyQcWorklistGuid + ",";
			insertDailyQc += TABLES.DailyQcWorklist.RackGuid + ",";
			insertDailyQc += TABLES.DailyQcWorklist.DailyUseIndicator + ",";
			insertDailyQc += TABLES.DailyQcWorklist.DailyQcExpirationDate + ",";
			insertDailyQc += TABLES.DailyQcWorklist.PartiallyTestedIndicator + ",";
			insertDailyQc += TABLES.PatientSpecimen.DivisionCode + ",";
			insertDailyQc += TABLES.Reagent.RecordStatusCode + ",";
			insertDailyQc += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertDailyQc += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertDailyQc += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertDailyQc += "VALUES (";
			insertDailyQc += "'" + dailyQcWorklistGuid.ToString() + "',";
			insertDailyQc += "'" + this._dtRack.Rows[0][TABLES.Rack.RackGuid].ToString() + "',";
			insertDailyQc += "'1',";
			insertDailyQc += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now.AddDays(5)) + "',";
			insertDailyQc += "'1',";
			insertDailyQc += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertDailyQc += "'A',";
			insertDailyQc += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertDailyQc += "'UnitTestUser',";
			insertDailyQc += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//
			Guid reagentGuid = Guid.NewGuid();
			string insertReagent = "INSERT INTO REAGENT (";
			insertReagent += TABLES.Reagent.ReagentGuid + ",";
			insertReagent += TABLES.Reagent.ReagentTypeId + ",";
			insertReagent += TABLES.Reagent.ReagentName + ",";
			insertReagent += TABLES.Reagent.LotNumber + ",";
			insertReagent += TABLES.PatientSpecimen.DivisionCode + ",";
			insertReagent += TABLES.Reagent.RecordStatusCode + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertReagent += "VALUES (";
			insertReagent += "'" + reagentGuid.ToString() + "',";
			insertReagent += "'1',";
			insertReagent += "'TestReagent',";
			insertReagent += "'53000',";
			insertReagent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertReagent += "'A',";
			insertReagent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertReagent += "'UnitTestUser',";
			insertReagent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			DateTime lotUseDate = DateTime.UtcNow;
			DateTime currentDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			
			Guid rackLotGuid = Guid.NewGuid();
			string insertRackLot = "INSERT INTO RACKLOT (";
			insertRackLot += TABLES.RackLot.RackLotGuid + ",";
			insertRackLot += TABLES.RackLot.ReagentGuid + ",";
			insertRackLot += TABLES.RackLot.DailyQcWorklistGuid + ",";
			insertRackLot += TABLES.RackLot.LotUseDate + ",";
			insertRackLot += TABLES.PatientSpecimen.DivisionCode + ",";
			insertRackLot += TABLES.Reagent.RecordStatusCode + ",";
			insertRackLot += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertRackLot += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertRackLot += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertRackLot += "VALUES (";
			insertRackLot += "'" + rackLotGuid.ToString() + "',";
			insertRackLot += "'" + reagentGuid.ToString() + "',";
			insertRackLot += "'" + dailyQcWorklistGuid.ToString() + "',";
			insertRackLot += "'" + Common.VBECSDateTime.FormatDateTimeString(lotUseDate) + "',";
			insertRackLot += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertRackLot += "'A',";
			insertRackLot += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertRackLot += "'UnitTestUser',";
			insertRackLot += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertDailyQc);
			UnitTestUtil.RunSQL(insertReagent);
			UnitTestUtil.RunSQL(insertRackLot);

			DateTime rackTestDate = BOL.Rack.GetRackTestDate( dailyQcWorklistGuid );
			Assert.IsTrue(rackTestDate.Date.Equals( currentDateTime.Date ) );
			Assert.IsTrue(rackTestDate.Minute.Equals( lotUseDate.Minute ) );
		}

		[Test]
		public void GetRackTestDate_Fail()
		{
			Assert.IsTrue( BOL.Rack.GetRackTestDate( Guid.NewGuid() ).Equals( DateTime.MinValue ) );
		}
	}
}
#endif



